<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Opname extends CI_Controller {

	public function __construct(){
		parent::__construct();
		$this->load->library('template');

		$this->load->model('m_opname');
		$this->load->model('default_mdl');
		$this->load->model('m_master');

		if(!$this->session->userdata("online")){
			redirect(site_url('login'));
		}
	}

	public function index()
	{	
		$reg_bukti_no = $this->uri->segment(3);
		$dt['data'] = $this->m_opname->getData();
		$this->template->display('v_opname',$dt);
	}

	public function data()
	{
		$reg_bukti_no = $this->uri->segment(3);
		$dt['data'] = $this->m_opname->getDataResepById($reg_bukti_no);
		$this->template->display('v_opname',$dt);
	}

	public function add()
	{
		// $reg_bukti_no = $this->uri->segment(3);
		// $dt['data'] = $this->m_opname->getDataById();
		$dt['instalasi'] = $this->m_master->instalasi();
		$dt['gudang'] = $this->m_master->gudang();
		$dt['dokter'] = $this->m_master->dokter();
		$dt['obat'] = $this->m_master->obat_permintaan();
		$this->template->display('v_opname_add',$dt);
	}
	
	public function edit()
	{
		$jual_bukti_no = $this->uri->segment(3);
		$dt['data'] = $this->m_opname->getDataResepDetailById($jual_bukti_no);
		$dt['instalasi'] = $this->m_master->instalasi();
		$dt['dokter'] = $this->m_master->dokter();
		$dt['obat'] = $this->m_master->obat();
		$this->template->display('v_opname_edit',$dt);
	}

	public function add_header()
	{

		
		$kode = $this->m_opname->kode();
		$gud_code = $this->input->post("gud_code");
		$gud_to = $this->input->post("gud_to");
		$req_urgen_date = $this->input->post("req_urgen_date");
		$req_notes = $this->input->post("req_notes");

		if($_POST){
			$query = $this->m_opname->add_header($kode,$gud_code,$gud_to,$req_urgen_date,$req_notes);

			if($query){
				$d["status"] = 1;
				$d["bukti_no"] = $kode;
				$d["gud_to"] = $gud_to;

			}
		} else {
			$d["status"] = 0;
		}

		echo json_encode($d);

	}

	public function cetak(){

		$jual_bukti_no = $this->uri->segment(3);

		ob_start();    


		#ambil data di tabel dan masukkan ke array
		$data['data'] = $this->m_opname->cetak($jual_bukti_no);
		$this->load->view('cetak',$data);

		$content = ob_get_clean();               
		require_once('./html2pdf/html2pdf.class.php');    
		try
		{
			$html2pdf = new HTML2PDF('L', array(40,70), 'en', true, 'UTF-8', array(1, 1, 1, 1));
			$html2pdf->pdf->SetDisplayMode('fullpage');
			$html2pdf->writeHTML($content, isset($_GET['vuehtml']));
			$html2pdf->Output('etiket.pdf');
		}
		catch(HTML2PDF_exception $e) {
			echo $e;
			exit;
		}


	}

	public function add_item()
	{

		
		$req_bukti_no = $this->input->post("req_bukti_no");
		$ob_code = $this->input->post("ob_code");
		$ob_qty = $this->input->post("ob_qty");
		$ob_harga = $this->input->post("ob_harga");
		$stok = $this->input->post("stok");

		if($_POST){
			$query = $this->m_opname->add_item($req_bukti_no,$ob_code,$ob_qty,$stok);

			if($query){
				
				$d["status"] = 1;
				$d["detail"] = "";

				$query_detail = $this->m_opname->getDataResepDetailById($req_bukti_no);
				
				foreach ($query_detail->result_array() as $row_d) {
					$d["detail"] .= '<tr>
										<td hidden>'.$row_d['ob_code'].'</td>
										<td>'.$row_d['ob_name'].'</td>
										<td>'.$row_d['req_qty'].'</td>
										<td>'.$row_d['sat_name'].'</td>
										<td>'.$row_d['saldo'].'</td>
										<td><a data-jual_bukti_no="'.$row_d['req_bukti_no'].'" data-id="'.$row_d['ob_code'].'" id="delete_item" class="btn btn-danger btn-xs"><span class="fa fa-trash"></span></a></td>
									</tr>';
				}



			}
		} else {
			$d["status"] = 0;
		}

		echo json_encode($d);

	}
	

	public function delete_item(){

		$jual_bukti_no = $this->input->post("jual_bukti_no");
		$id = $this->input->post("id");
		$query = $this->m_opname->delete_item($jual_bukti_no,$id);
		$query_ins = $this->m_opname->delete_item_jual($jual_bukti_no,$id);

		if($query){
			$output = "";
			$query_detail = $this->m_opname->getDataResepDetailById($jual_bukti_no);
				
			foreach ($query_detail->result_array() as $row_d) {
				$output .= '<tr>
									<td hidden>'.$row_d['ob_code'].'</td>
									<td>'.$row_d['ob_name'].'</td>
									<td>'.$row_d['ob_qty'].'</td>
									<td>'.$row_d['sat_name'].'</td>
									<td>'.$row_d['saldo'].'</td>
									<td>'.number_format($row_d['ob_jual']).'</td>
									<td>'.number_format($row_d['total_val']).'</td>
									<td>'.$row_d['rsp_cara'].'</td>
									<td>'.$row_d['rsp_dosis'].'</td>
									<td>'.$row_d['rsp_jam'].'</td>
									<td>'.$row_d['rsp_sat_minum'].'</td>
									<td><a data-jual_bukti_no="'.$row_d['jual_bukti_no'].'" data-id="'.$row_d['ob_code'].'" id="delete_item" class="btn btn-danger btn-xs"><span class="fa fa-trash"></span></a></td>
								</tr>';
			}
		} else {
			$output = 0;
		}

		echo $output;
		


	}

	public function delete(){

		$jual_bukti_no = $this->input->post("jual_bukti_no");
		$query = $this->m_opname->delete($jual_bukti_no);
		$query = $this->m_opname->delete_hpp($jual_bukti_no);

		if($query){
			$output = 1;
		} else {
			$output = 0;
		}

		echo $output;
		


	}

	public function stok()
	{
		
		$ob_code = $this->input->post("ob_code");
		$gud_code = $this->input->post("gud_to");

		$row = $this->m_master->stok_all($gud_code,$ob_code)->row_array();

		$r['saldo'] = $row['saldo'];
		$r['harga'] = $row['ob_jual'];

		echo json_encode($r);


	}
	





}

/* End of file Kategori.php */
/* Location: ./application/controllers/Kategori.php */