<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Login extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->library('template');
		$this->load->model('m_login');
		$this->load->model('m_master');
	}

	public function index()
	{
		$dt['shift'] = $this->m_master->shift();
		$this->load->view('v_login',$dt);
	}

	public function cek_login()
	{


		$validation = $this->form_validation->set_rules($this->m_login->rules());

		if ($this->form_validation->run() == TRUE) {

			// cek status login
			$cek = $this->m_login->cek_login();

			if ($cek == 1) {


				// echo "berhasil";
				$data = $this->m_login->getData();


				// buat session
				$session = array(
					'ses_user_login' 	=> $data->user_login,
					'ses_divisi' 	=> $data->div_id,
					'ses_gudang' 	=> $data->gud_code,
					'ses_gudang_name' 	=> $data->gud_name,
					'ses_cabang' 	=> $data->cab_code,
					'ses_ip_address' 	=> $this->input->ip_address(),
					'ses_shift' 	=> $this->input->post('shift_code'),
					'online' 			=> true
				);

				$this->session->set_userdata($session);

				// redirect(site_url('dashboard'));

				redirect(site_url('resep'));
			} else if ($cek == 0) {

				$this->session->set_flashdata('message', 'Username anda tidak terdaftar !');
				redirect('login');
			} else {

				$this->session->set_flashdata('message', 'Password anda salah !');
				redirect('login');
			}
		} else {


			$this->load->view('v_login');
		}
	}

	public function rubah_password()
	{
		$dt['peg_code'] = $this->session->userdata('ses_peg_code');
		$this->template->display('v_rubah_password', $dt);
	}

	public function logout()
	{

		$this->session->unset_userdata('ses_user_login');
		$this->session->unset_userdata('ses_ip_address');
		$this->session->unset_userdata('ses_shift');
		$this->session->unset_userdata('online');
		$this->session->sess_destroy();
		redirect(site_url('login'));
	}

	public function update_password()
	{

		// cek
		$cek = $this->m_login->cek_username();

		if ($cek == 1) {
			echo "<script>alert('Password berhasil di rubah !')</script>";

			$this->session->unset_userdata('ses_user_login');
			$this->session->unset_userdata('ses_ip_address');
			$this->session->unset_userdata('ses_shift');
			$this->session->unset_userdata('online');
			$this->session->sess_destroy();
			echo "<script>window.location='" . site_url('login') . "';</script>";
		} else {
			echo "<script>alert('Password gagal di rubah !')</script>";
			redirect('login/rubah_password');
		}
	}
}

/* End of file Login.php */
/* Location: ./application/controllers/Login.php */