<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Bhp extends CI_Controller {

	public function __construct(){
		parent::__construct();
		$this->load->library('template');

		$this->load->model('m_bhp');
		$this->load->model('m_retur');
		$this->load->model('default_mdl');
		$this->load->model('m_master');

		if(!$this->session->userdata("online")){
			redirect(site_url('login'));
		}
	}

	public function index()
	{

		$dt['instalasi'] = $this->m_master->instalasi();
		$dt['dokter'] = $this->m_master->dokter();
		$dt['data'] = $this->m_bhp->getData();
		$this->template->display('v_bhp_add',$dt);
	}

	public function data()
	{
		$dt['data'] = $this->m_bhp->getData();
		$this->template->display('v_bhp', $dt);
	}

	// public function data()
	// {

		
	// 	$results = $this->m_bhp->getData();
	// 	$data = [];
	// 	$no = $_POST['start'];
	// 	foreach ($results as $result) {
	// 		$row = array();
	// 		$row[] = ++$no;
	// 		$row[] = $result->reg_bukti_no;
	// 		$row[] = $result->reg_bukti_date;
	// 		$row[] = $result->pas_code;
	// 		$row[] = $result->pas_name;
	// 		$row[] = $result->ins_name;
	// 		$row[] = '<a href="'.base_url().'index.php/bhp/data/'.$result->reg_bukti_no.'" class="btn btn-primary btn-xs"><span class="fa fa-plus"></span>Data Resep</a>&nbsp;&nbsp;
	// 		<a onclick="input_resep(&apos;'.$result->reg_bukti_no.'&apos;)" class="btn btn-success btn-xs"><span class="fa fa-plus"></span>Input Resep</a>';
	// 		$data[] = $row;
	// 	}

	// 	$output = array(
	// 		"draw" => $_POST['draw'],
	// 		"recordsTotal" => $this->m_bhp->count_all_data(),
	// 		"recordsFiltered" => $this->m_bhp->count_filtered_data(),
	// 		"data" => $data,
	// 	);

	// 	$this->output->set_content_type('application/json')->set_output(json_encode($output));
		
	// }


	public function add()
	{
		$reg_bukti_no = $this->uri->segment(4);
		$dt['data'] = $this->m_bhp->getDataById($reg_bukti_no);
		$dt['instalasi'] = $this->m_master->instalasi();
		$dt['dokter'] = $this->m_master->dokter();
		$dt['obat'] = $this->m_master->obat();
		$this->template->display('v_bhp_add',$dt);
	}
	
	public function edit()
	{
		$alkes_bukti_no = $this->uri->segment(3);
		$dt['data'] = $this->m_bhp->getDataResepDetailById($alkes_bukti_no);
		$dt['instalasi'] = $this->m_master->instalasi();
		$dt['dokter'] = $this->m_master->dokter();
		$dt['obat'] = $this->m_master->obat();
		$this->template->display('v_bhp_edit',$dt);
	}

	public function add_header()
	{

		
		$kode = $this->m_bhp->kode();
		$reg_bukti_no = $this->input->post("reg_bukti_no");

		if($_POST){
			$query = $this->m_bhp->add_header($kode,$reg_bukti_no);

			if($query){
				$d["status"] = 1;
				$d["bukti_no"] = $kode;

			}
		} else {
			$d["status"] = 0;
		}

		echo json_encode($d);

	}

	public function cetak(){

		$alkes_bukti_no = $this->uri->segment(3);

		ob_start();    


		#ambil data di tabel dan masukkan ke array
		$data['data'] = $this->m_bhp->cetak($alkes_bukti_no);
		$this->load->view('cetak',$data);

		$content = ob_get_clean();               
		require_once('./html2pdf/html2pdf.class.php');    
		try
		{
			$html2pdf = new HTML2PDF('L', array(40,65), 'en', true, 'UTF-8', array(1, 1, 1, 1));
			$html2pdf->pdf->SetDisplayMode('fullpage');
			$html2pdf->writeHTML($content, isset($_GET['vuehtml']));
			$html2pdf->Output('etiket.pdf');
		}
		catch(HTML2PDF_exception $e) {
			echo $e;
			exit;
		}


	}

	public function add_item()
	{

		
		$alkes_bukti_no = $this->input->post("alkes_bukti_no");
		$ob_code = $this->input->post("ob_code");
		$ob_qty = $this->input->post("ob_qty");
		$ob_harga = $this->input->post("ob_harga");
		$ob_beli = $this->input->post("ob_beli");
		$stok = $this->input->post("stok");

		if($_POST){

				$query = $this->m_bhp->add_item($alkes_bukti_no,$ob_code,$ob_qty,$ob_harga,$ob_beli,$stok);

				if($query){
					
					$d["status"] = 1;
					$d["detail"] = "";

					$query_detail = $this->m_bhp->getDataResepDetailById($alkes_bukti_no);
					
					foreach ($query_detail->result_array() as $row_d) {
						$d["detail"] .= '<tr>
											<td hidden>'.$row_d['ob_code'].'</td>
											<td>'.$row_d['ob_name'].'</td>
											<td>'.$row_d['ob_qty'].'</td>
											<td>'.$row_d['sat_name'].'</td>
											<td>'.$row_d['saldo'].'</td>
											<td>'.number_format($row_d['ob_harga']).'</td>
											<td>'.number_format($row_d['ob_amount']).'</td>
											<td><a data-alkes_bukti_no="'.$row_d['alkes_bukti_no'].'" data-id="'.$row_d['ob_code'].'" id="delete_item" class="btn btn-danger btn-xs"><span class="fa fa-trash"></span></a></td>
										</tr>';
					}



				}
		
		} else {
			$d["status"] = 0;
		}

		echo json_encode($d);

	}

	public function cari_bhp()
	{
		$json = [];
		
		$this->db->where('gud_code', $this->session->userdata("ses_gudang"));
		// $this->db->where('tipe_name','BAKHP');
			$query = $this->db->select('*')
				->get("v_m_inv_obat_form_apotik_new");
			$json = $query->result_array();

		echo json_encode($json);

	}

	public function save()
	{
		$kode = $this->m_bhp->kode();

		$reg_bukti_no = $this->input->post("reg_bukti_no");

		$save_header = $this->m_bhp->add_header($kode,$reg_bukti_no);

		if ($save_header) {
			$no_array = 0;
			foreach ($this->input->post("ob_code") as $d) {
				if(!empty($d)){
					$ob_code = $_POST['ob_code'][$no_array];
					$ob_qty = $_POST['rsp_qty'][$no_array];
					$ob_harga = $_POST['ob_jual'][$no_array];
					$ob_beli = $_POST['ob_beli'][$no_array];
					$stok = $_POST['saldo'][$no_array];

					$save_detail = $this->m_bhp->add_item($kode,$ob_code,$ob_qty,$ob_harga,$ob_beli,$stok);
					
				}
				$no_array++;
			}

			$json["status"] = 1;
			$json["bukti_no"] = $kode;
		} else {
			$json["status"] = 0;
		}

		echo json_encode($json);
	}
	

	public function delete_item(){

		$alkes_bukti_no = $this->input->post("alkes_bukti_no");
		$id = $this->input->post("id");
		$query = $this->m_bhp->delete_item($alkes_bukti_no,$id);
		$query_ins = $this->m_bhp->delete_item_jual($alkes_bukti_no,$id);

		if($query){
			$output = "";
			$query_detail = $this->m_bhp->getDataResepDetailById($alkes_bukti_no);
				
			foreach ($query_detail->result_array() as $row_d) {
				$output .= '<tr>
									<td hidden>'.$row_d['ob_code'].'</td>
									<td>'.$row_d['ob_name'].'</td>
									<td>'.$row_d['ob_qty'].'</td>
									<td>'.$row_d['sat_name'].'</td>
									<td>'.$row_d['saldo'].'</td>
									<td>'.number_format($row_d['ob_harga']).'</td>
									<td>'.number_format($row_d['ob_amount']).'</td>
									<td><a data-alkes_bukti_no="'.$row_d['alkes_bukti_no'].'" data-id="'.$row_d['ob_code'].'" id="delete_item" class="btn btn-danger btn-xs"><span class="fa fa-trash"></span></a></td>
								</tr>';
			}
		} else {
			$output = 0;
		}

		echo $output;
		


	}

	public function delete(){

		$alkes_bukti_no = $this->uri->segment(3);

		// cek apakah bhp sudah ada yang di retur
		// juka sudah delete retur terlebih dahulu 

		$cekReturInput = $this->m_retur->cekRetur($alkes_bukti_no);
		$num = $cekReturInput->num_rows();

		if($num >= 1){

			$delete = $this->m_retur->deleteReturInap($alkes_bukti_no);
			if($delete){
				$delete_bhp = $this->m_bhp->delete($alkes_bukti_no);

				redirect(site_url('bhp/data'));
			}
		} else {
			$delete_bhp = $this->m_bhp->delete($alkes_bukti_no);

			redirect(site_url('bhp/data'));
		}
	
	}

	public function stok()
	{
		
		$ob_code = $this->input->post("ob_code");

		$row = $this->m_master->stok($ob_code)->row_array();

		$r['saldo'] = $row['saldo'];
		$r['harga'] = $row['ob_jual'];

		echo json_encode($r);


	}
	





}

/* End of file Kategori.php */
/* Location: ./application/controllers/Kategori.php */