<?php
error_reporting(0);
defined('BASEPATH') or exit('No direct script access allowed');


class M_resep extends CI_Model
{



	// private $id;
	// private $kat_kode;
	var $tabel_data = 'v_t_registrasi_transaksi_tindakan_jalan';
	var $column_order = array('id', 'reg_bukti_no', 'reg_bukti_date', 'pas_code', 'pas_name', 'ins_name');
	var $order = array('id', 'reg_bukti_no', 'reg_bukti_date', 'pas_code', 'pas_name', 'ins_name');

	private $tbl_resep = "t_resep_obat";
	private $tbl_resep_temp = "t_resep_obat_temp";
	private $tbl_resep_detail = "t_resep_obat_detail";
	private $tbl_resep_detail_temp = "t_resep_obat_detail_temp";

	public function __construct()
	{
		parent::__construct();

		// Load Models - Model_1 and Model_2
		$this->load->model('m_resep');
	}

	private function _get_data_query()
	{
		$this->db->from($this->tabel_data);
		if (isset($_POST['search']['value'])) {
			$this->db->like('pas_code', $_POST['search']['value']);
			$this->db->or_like('pas_name', $_POST['search']['value']);
		}

		if (isset($_POST['order'])) {
			$this->db->order_by($this->order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		} else {
			$this->db->order_by('reg_bukti_date');
		}
	}

	function getData()
	{

		$this->_get_data_query();
		if ($_POST['length'] != -1) {
			$this->db->limit($_POST['length'], $_POST['start']);
		}

		$query = $this->db->get();
		return $query->result();
		// $result = $this->db->query("SELECT * FROM v_t_registrasi_transaksi_tindakan_bhp ORDER BY reg_bukti_time DESC");		
		// return $result->result();
	}

	public function count_filtered_data()
	{
		$this->_get_data_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function count_all_data()
	{
		$this->db->from($this->tabel_data);
		return $this->db->count_all_results();
	}


	function kode($prefix)
	{

		$q = $this->db->query("SELECT MAX(RIGHT(rsp_bukti_no,6)) as rsp_bukti_no FROM t_resep_obat");
		$kd = "";
		if ($q->num_rows() > 0) {
			foreach ($q->result() as $k) {
				$tmp = ((int)$k->rsp_bukti_no) + 1;
				$kd = sprintf("%06s", $tmp);
			}
		} else {
			$kd = $prefix . "000001";
		}

		return $prefix . $kd;
	}

	function kode_temp($prefix)
	{

		$q = $this->db->query("SELECT a.rsp_bukti_no FROM
        (SELECT RIGHT(rsp_bukti_no,6) AS rsp_bukti_no FROM t_resep_obat 
        UNION ALL
       SELECT RIGHT(rsp_bukti_no,6) AS rsp_bukti_no FROM t_resep_obat_temp ) a ORDER BY a.rsp_bukti_no DESC LIMIT 1");
		$kd = "";
		if ($q->num_rows() > 0) {
			foreach ($q->result() as $k) {
				$tmp = ((int)$k->rsp_bukti_no) + 1;
				$kd = sprintf("%06s", $tmp);
			}
		} else {
			$kd = $prefix . "000001";
		}

		return $prefix . $kd;
	}

	function rsp_temp($kode_temp)
	{
		$data = [
			'rsp_bukti_no' => $kode_temp,
			'user_login' => $this->session->userdata('ses_user_login')
		];

		return $this->db->insert($this->tbl_resep_temp, $data);
	}

	function delRspTemp()
	{
		$user_login = $this->session->userdata('ses_user_login');
		$result = $this->db->query("DELETE FROM t_resep_obat_temp WHERE user_login='$user_login'");
		return $result;
	}

	// function getData(){

	// 	// $result = $this->db->query("SELECT * FROM v_t_registrasi_transaksi_tindakan_jalan WHERE reg_bukti_date=DATE(NOW()) ORDER BY reg_bukti_time");		
	// 	$result = $this->db->query("SELECT * FROM v_t_registrasi_transaksi_tindakan_jalan ORDER BY reg_bukti_time");		
	// 	return $result;
	// }

	function getDataById($reg_bukti_no)
	{

		$result = $this->db->query("SELECT * FROM v_t_registrasi_transaksi_tindakan_jalan WHERE reg_bukti_no='$reg_bukti_no' ");
		return $result;
	}

	function getDataResep()
	{

		$result = $this->db->query("SELECT * FROM v_t_resep_obat_all_active");
		return $result;
	}

	function getDataResepDetailById($rsp_bukti_no)
	{

		//$result = $this->db->query("SELECT * FROM v_t_resep_obat_detail WHERE rsp_bukti_no='$rsp_bukti_no'");

		try {
			$this->db->reconnect();
			$sql = "CALL `p_t_resep_obat_detail`('$rsp_bukti_no')";
			$result = $this->db->query($sql);
			$this->db->close();
		} catch (Exception $e) {
			echo $e->getMessage();
		}

		return $result;
	}

	function getDataResepDetailTempByUser()
	{
		$update_user = $this->session->userdata('ses_user_login');
		$result = $this->db->query("SELECT * FROM v_t_resep_obat_detail_temp WHERE update_user='$update_user'");
		return $result;
	}

	function add_header($kode, $reg_bukti_no, $dok_code, $pas_name)
	{

		$data = [
			'rsp_bukti_no' => $kode,
			'rsp_bukti_date' => date('Y-m-d'),
			'reg_bukti_no' => $reg_bukti_no,
			'dok_code'    => $dok_code,
			'pas_name'    => $pas_name,
			'gud_code' => $this->session->userdata("ses_gudang"),
			'cab_code' => $this->session->userdata("ses_cabang"),
			'shift_code' => $this->session->userdata("ses_shift"),
			'update_user' => $this->session->userdata('ses_user_login'),
			'update_datetime' => date('Y-m-d h:i:s'),
			'update_ip' => $this->input->ip_address(),
			'update_count' => 0
		];

		return $this->db->insert($this->tbl_resep, $data);
	}


	function add_item($rsp_bukti_no, $ob_code, $ob_qty, $ob_harga, $ob_beli, $stok, $rsp_cara, $rsp_dosis, $rsp_jam, $rsp_sat_minum, $ob_racik)
	{



		$data = [
			'rsp_bukti_no' => $rsp_bukti_no,
			'ob_code' => $ob_code,
			'rsp_qty' => $ob_qty,
			'ob_jual'    => $ob_harga,
			'ob_beli'    => $ob_beli,
			'saldo'    => $stok,
			'rsp_cara'    => $rsp_cara,
			'rsp_dosis'    => $rsp_dosis,
			'rsp_jam'    => $rsp_jam,
			'rsp_sat_minum'    => $rsp_sat_minum,
			'ob_racik'    => $ob_racik,
			'sts'    => 1,
			'update_user' => $this->session->userdata('ses_user_login'),
			'update_datetime' => date('Y-m-d h:i:s'),
			'update_ip' => $this->input->ip_address(),
			'update_count' => 0
		];

		return $this->db->insert($this->tbl_resep_detail, $data);
	}


	// function delete($rsp_bukti_no){
	// 	$result = $this->db->query("DELETE FROM t_resep_obat WHERE rsp_bukti_no='$rsp_bukti_no'");
	// 	return $result;
	// }

	// function delete_item_temp($id){
	// 	$result = $this->db->query("DELETE FROM t_resep_obat_detail_temp WHERE id='$id'");
	// 	return $result;
	// }

	// function delete_item_jual($bukti_no,$id){
	// 	$result = $this->db->query("DELETE FROM hpp_gudang WHERE bukti_no='$bukti_no' and ob_code='$id'");
	// 	return $result;
	// }

	function cetak($rsp_bukti_no)
	{

		try {
			$this->db->reconnect();
			$sql = "CALL p_label_resep ('$rsp_bukti_no')";
			$result = $this->db->query($sql)->result(); // $data included 3 param and binding & query to db
			$this->db->close();
		} catch (Exception $e) {
			echo $e->getMessage();
		}
		return $result;
	}

	function cetak_erm($rsp_bukti_no)
	{

		try {
			$this->db->reconnect();
			$sql = "CALL p_label_resep_erm ('$rsp_bukti_no')";
			$result = $this->db->query($sql)->result(); // $data included 3 param and binding & query to db
			$this->db->close();
		} catch (Exception $e) {
			echo $e->getMessage();
		}
		return $result;
	}

	function paket($pkt_code)
	{

		$result = $this->db->query("SELECT * FROM v_m_inv_obat_paket_foreign_new WHERE pkt_code='$pkt_code'");
		return $result;
	}

	function pasien_all_active_by_pasien($pas_code)
	{
		$result =  $this->db->query("SELECT * FROM v_t_registrasi_all_active WHERE pas_code='$pas_code'");

		return $result;
	}

	function pasien_all_active_filter()
	{
		$result =  $this->db->query("SELECT * FROM v_t_registrasi_all_active");

		return $result;
	}

	function delete($rsp_bukti_no)
	{
		$result = $this->db->query("DELETE FROM t_resep_obat WHERE rsp_bukti_no='$rsp_bukti_no'");
		return $result;
	}






	// function getDataById($id){

	// 	$result = $this->db->query("SELECT* FROM v_bon_koperasi_portal WHERE md5(CONCAT(peg_code,'#',DATE_FORMAT(pb_bukti_date,'%m%Y')))='".$id."'");
	// 	return $result;
	// }




}

/* End of file m_kategori.php */
/* Location: ./application/models/m_kategori.php */