<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Retur_bhp extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('template');

		$this->load->model('m_retur_bhp');
		$this->load->model('default_mdl');
		$this->load->model('m_master');

		if (!$this->session->userdata("online")) {
			redirect(site_url('login'));
		}
	}

	// public function index()
	// {
	// 	$dt['instalasi'] = $this->m_master->instalasi();
	// 	$dt['dokter'] = $this->m_master->dokter();
	// 	$this->template->display('v_retur_bhp', $dt);
	// }

    public function form()
	{
        $rsp_bukti_no = $this->uri->segment(3);
		$dt['data'] = $this->m_retur_bhp->getDataResepDetailById($rsp_bukti_no)->result_array();
		$this->template->display('v_retur_bhp', $dt);
	}

	public function data()
	{
		$dt['data'] = $this->m_resep->getDataResep();
		$this->template->display('v_resep', $dt);
	}	
	
	public function save()
	{
		$kode = $this->m_retur_bhp->kode('24');
        
		$rsp_bukti_no = $this->input->post("bukti_no");

        $data = [
			'iprjual_bukti_no' => $kode,
			'iprjual_bukti_date' => date('Y-m-d'),
			'ipjual_bukti_no' => $rsp_bukti_no,
			'gud_code' => $this->session->userdata("ses_gudang"),
			'cab_code' => $this->session->userdata("ses_cabang"),
			'update_user' => $this->session->userdata('ses_user_login'),
			'update_datetime' => date('Y-m-d h:i:s'),
			'update_ip' => $this->input->ip_address(),
			'update_count' => 0
		];
		
        $save_header = $this->m_retur_bhp->add_header($data);
            
            if ($save_header) {
                $no_array = 0;
                foreach ($_POST['ob_code'] as $d) {
                    if(!empty($d)){
                        $ob_code = $_POST['ob_code'][$no_array];
                        $ob_qty = $_POST['ob_qty'][$no_array];
                        $rob_qty = $_POST['rob_qty'][$no_array];
                        $ob_harga = $_POST['ob_harga'][$no_array];

                        if($rob_qty > 0) {
                            $data_detail = [
                                'iprjual_bukti_no' => $kode,
                                'ob_code' => $ob_code,
                                'ob_qty' => $ob_qty,
                                'rob_harga'    => $ob_harga,
                                'rob_qty'    => $rob_qty,
                                'update_user' => $this->session->userdata('ses_user_login'),
                                'update_datetime' => date('Y-m-d h:i:s'),
                                'update_ip' => $this->input->ip_address(),
                                'update_count' => 0
                            ];
                            $save_detail = $this->m_retur_bhp->add_item($data_detail);
                        }
                        
                        
                    }
    
                    $no_array++;
                }
    
                
                
                $json["status"] = 1;
                $json["bukti_no"] = $kode;
            } else {
                $json["status"] = 0;
            }

		

		echo json_encode($json);
	}
}
