<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Retur extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('template');

		$this->load->model('m_retur');
		$this->load->model('default_mdl');
		$this->load->model('m_master');

		if (!$this->session->userdata("online")) {
			redirect(site_url('login'));
		}
	}

	public function index()
	{
		$dt['instalasi'] = $this->m_master->instalasi();
		$dt['dokter'] = $this->m_master->dokter();
		$this->template->display('v_retur', $dt);
	}

    public function form()
	{
        $rsp_bukti_no = $this->uri->segment(3);
		$dt['data'] = $this->m_retur->getDataResepDetailById($rsp_bukti_no)->result_array();
		$this->template->display('v_retur', $dt);
	}

	public function data()
	{
		$dt['data'] = $this->m_resep->getDataResep();
		$this->template->display('v_resep', $dt);
	}	
	
	public function save()
	{
        $kel_code = $this->input->post("kel_code");
		
		$kode = ($kel_code == "001" ? $this->m_retur->kode_ip('24') : $this->m_retur->kode_op('27'));
        
		$rsp_bukti_no = $this->input->post("bukti_no");
		
        if($kel_code == "001"){
            
            $save_header = $this->m_retur->add_header_ip($kode,$rsp_bukti_no);
            
            if ($save_header) {
                $no_array = 0;
                foreach ($_POST['ob_code'] as $d) {
                    if(!empty($d)){
                        $ob_code = $_POST['ob_code'][$no_array];
                        $ob_qty = $_POST['rsp_qty'][$no_array];
                        $rob_qty = $_POST['rob_qty'][$no_array];
                        $ob_harga = $_POST['ob_jual'][$no_array];

                        if($rob_qty > 0) {
                            $save_detail = $this->m_retur->add_item_ip($kode,$ob_code,$ob_qty,$ob_harga,$rob_qty);
                        }
                        
                        
                    }
    
                    $no_array++;
                }
    
                
                
                $json["status"] = 1;
                $json["bukti_no"] = $kode;
            } else {
                $json["status"] = 0;
            }

        } else {
            $save_header_op = $this->m_retur->add_header_op($kode,$rsp_bukti_no);
            
            if ($save_header_op) {
                $no_array = 0;
                foreach ($_POST['ob_code'] as $d) {
                    if(!empty($d)){
                        $ob_code = $_POST['ob_code'][$no_array];
                        $ob_qty = $_POST['rsp_qty'][$no_array];
                        $rob_qty = $_POST['rob_qty'][$no_array];
                        $ob_harga = $_POST['ob_jual'][$no_array];
                        
                        $save_detail_op = $this->m_retur->add_item_op($kode,$ob_code,$ob_qty,$ob_harga,$rob_qty);
                        
                    }
    
                    $no_array++;
                }
    
                
                
                $json["status"] = 1;
                $json["bukti_no"] = $kode;
            } else {
                $json["status"] = 0;
            }
        }
		
		

		echo json_encode($json);
	}
}
