<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Resep extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('template');

		$this->load->model('m_retur');
		$this->load->model('m_resep');
		$this->load->model('default_mdl');
		$this->load->model('m_master');

		if (!$this->session->userdata("online")) {
			redirect(site_url('login'));
		}
	}

	public function index()
	{
		$dt['instalasi'] = $this->m_master->instalasi();
		$dt['dokter'] = $this->m_master->dokter();
		$this->template->display('v_resep_add', $dt);
	}

	public function data()
	{
		$dt['data'] = $this->m_resep->getDataResep();
		$this->template->display('v_resep', $dt);
	}

	public function cari_pasien()
	{

		$json = [];

		$query = $this->db->select('*')
			->get("v_t_registrasi_active");
		$json = $query->result_array();

		echo json_encode($json);
	}

	public function cari_obat()
	{
		$json = [];

		$this->db->where('gud_code', $this->session->userdata("ses_gudang"));
		$query = $this->db->select('*')
			->get("v_m_inv_obat_form_apotik_new");
		$json = $query->result_array();

		echo json_encode($json);
	}

	public function cetak()
	{

		$rsp_bukti_no = $this->uri->segment(3);

		ob_start();

		$data['data'] = $this->m_resep->cetak($rsp_bukti_no);

		$this->load->view('cetak', $data);

		$content = ob_get_clean();
		require_once('./html2pdf/html2pdf.class.php');
		try {
			$html2pdf = new HTML2PDF('L', array(40, 65), 'en', true, 'UTF-8', array(1, 1, 1, 1));
			$html2pdf->pdf->SetDisplayMode('fullpage');
			$html2pdf->writeHTML($content, isset($_GET['vuehtml']));
			$html2pdf->Output('etiket.pdf');
		} catch (HTML2PDF_exception $e) {
			echo $e;
			exit;
		}
	}


	public function save()
	{
		$kel_code = $this->input->post("kel_code");

		$kode_temp = $this->m_resep->kode_temp('04');
		$this->m_resep->rsp_temp($kode_temp);
		$kode_rajal = $this->m_resep->kode_temp('04');
		$kode = ($kel_code == "001" ? $this->m_resep->kode('IP') : $kode_rajal);

		$reg_bukti_no = $this->input->post("reg_bukti_no");
		$dok_code = $this->input->post("dok_code");
		$pas_name = $this->input->post("pas_name");

		$save_header = $this->m_resep->add_header($kode, $reg_bukti_no, $dok_code, $pas_name);

		if ($save_header) {
			$this->m_resep->delRspTemp();
			$no_array = 0;
			foreach ($_POST['ob_code'] as $d) {
				if (!empty($d)) {
					$ob_code = $_POST['ob_code'][$no_array];
					$ob_qty = $_POST['rsp_qty'][$no_array];
					$ob_harga = $_POST['ob_jual'][$no_array];
					$ob_beli = $_POST['ob_beli'][$no_array];
					$stok = $_POST['saldo'][$no_array];
					$rsp_cara = $_POST['rsp_cara'][$no_array];
					$rsp_dosis = $_POST['rsp_dosis'][$no_array];
					$rsp_jam = $_POST['rsp_jam'][$no_array];
					$rsp_sat_minum = $_POST['rsp_sat_minum'][$no_array];
					$ob_racik = $_POST['ob_racik'][$no_array];

					$save_detail = $this->m_resep->add_item($kode, $ob_code, $ob_qty, $ob_harga, $ob_beli, $stok, $rsp_cara, $rsp_dosis, $rsp_jam, $rsp_sat_minum, $ob_racik);
				}

				$no_array++;
			}



			$json["status"] = 1;
			$json["bukti_no"] = $kode;
		} else {
			$json["status"] = 0;
		}

		echo json_encode($json);
	}

	public function add_paket()
	{

		$pkt_code = $this->input->post("pkt_code");

		if ($_POST) {

			$pkt = $this->m_resep->paket($pkt_code);
			$d["detail"] = '';
			foreach ($pkt->result_array() as $rp) {

				$ob_code = $rp['ob_code'];
				$ob_qty = $rp['ob_qty'];
				$ob_harga = $rp['ob_harga'];
				$ob_beli = $rp['ob_beli'];
				$stok = $rp['saldo'];
				$ob_name = $rp['ob_name'];
				$sat_name = $rp['sat_name'];
				$amount = $ob_harga * $ob_qty;
				$rsp_cara = "";
				$rsp_dosis = "";
				$rsp_jam = "";
				$rsp_sat_minum = "";
				$ob_racik = "";

				$d["status"] = 1;

				$qty = 0;
				$total = 0;
				$d["detail"] .= '<tr>
										<td hidden><input type="hidden" name="ob_code[]" value="' . $ob_code . '">' . $ob_code . '</td>
										<td>' . $ob_name . '</td>
										<td><input type="text" class="form-control" id="rsp_qty" name="rsp_qty[]" value="' . $ob_qty . '"></td>
										<td>' . $sat_name . '</td>
										<td><input type="hidden" name="saldo[]" value="' . $stok . '">' . $stok . '</td>
										<td><input type="hidden" name="ob_jual[]" value="' . $ob_harga . '">' . number_format($ob_harga) . '</td>
										<td hidden><input type="hidden" name="ob_beli[]" value="' . $ob_beli . '"></td>
										<td><input type="hidden" name="amount" value="' . $amount . '">' . number_format($amount) . '</td>
										<td><input type="hidden" name="rsp_cara[]" value="' . $rsp_cara . '">' . $rsp_cara . '</td>
										<td><input type="hidden" name="rsp_dosis[]" value="' . $rsp_dosis . '">' . $rsp_dosis . '</td>
										<td><input type="hidden" name="rsp_jam[]" value="' . $rsp_jam . '">' . $rsp_jam . '</td>
										<td><input type="hidden" name="rsp_sat_minum[]" value="' . $rsp_sat_minum . '">' . $rsp_sat_minum . '</td>
										<td><input type="hidden" name="ob_racik[]" value="' . $ob_racik . '">' . $ob_racik . '</td>
										<td><a class="delete_item btn btn-danger btn-xs"><span class="fa fa-trash"></span></a></td>
										</tr>
										';
			}
		} else {
			$d["status"] = 0;
		}

		echo json_encode($d);
	}

	public function delete()
	{

		$rsp_bukti_no = $this->uri->segment(3);

		// cek apakah bhp sudah ada yang di retur
		// juka sudah delete retur terlebih dahulu 

		$cekReturInput = $this->m_retur->cekRetur($rsp_bukti_no);
		$num = $cekReturInput->num_rows();
		// echo $dataResep["ket"];
		// var_dump($dataResep);
		// exit();

		if ($num >= 1) {
			$dataResep = $cekReturInput->row_array();
			if ($dataResep["ket"] == "RI") {
				$delete = $this->m_retur->deleteReturInap($rsp_bukti_no);
			} else {
				$delete = $this->m_retur->deleteReturJalan($rsp_bukti_no);
			}

			if ($delete) {
				$delete_resep = $this->m_resep->delete($rsp_bukti_no);

				redirect(site_url('resep/data'));
			}
		} else {
			$delete_resep = $this->m_resep->delete($rsp_bukti_no);

			redirect(site_url('resep/data'));
		}
	}

	// public function load_item_temp()
	// {
	// 	$html = '';
	// 	$query_detail = $this->m_resep->getDataResepDetailTempByUser();
	// 	$qty = 0;
	// 	$total = 0;
	// 	foreach ($query_detail->result_array() as $row_d) {
	// 		$html .= '<tr>
	// 		<td hidden>' . $row_d['ob_code'] . '</td>
	// 		<td>' . $row_d['ob_name'] . '</td>
	// 										<td>' . $row_d['rsp_qty'] . '</td>
	// 										<td>' . $row_d['sat_name'] . '</td>
	// 										<td>' . $row_d['saldo'] . '</td>
	// 										<td>' . number_format($row_d['ob_jual']) . '</td>
	// 										<td>' . number_format($row_d['ob_amount']) . '</td>
	// 										<td>' . $row_d['rsp_cara'] . '</td>
	// 										<td>' . $row_d['rsp_dosis'] . '</td>
	// 										<td>' . $row_d['rsp_jam'] . '</td>
	// 										<td>' . $row_d['rsp_sat_minum'] . '</td>
	// 										<td>' . $row_d['ob_racik'] . '</td>
	// 										<td><a onclick="delete_item(&apos;'.$row_d['id'].'&apos;)" class="btn btn-danger btn-xs"><span class="fa fa-trash"></span></a></td>
	// 										</tr>
	// 										';

	// 										$qty = $qty + $row_d['rsp_qty'];
	// 										$total = $total + $row_d['ob_amount'];
	// 									}

	// 									$html .= '<tr style="font-weight:bold;">
	// 									<td>Total</td>
	// 									<td>' . $qty . '</td>
	// 									<td colspan=3></td>
	// 									<td>' . number_format($total) . '</td>
	// 									<td colspan=6></td>
	// 									</tr>';

	// 									echo $html;
	// 								}

	// public function delete_item_temp()
	// 								{

	// 	$id = $this->input->post("id");
	// 	$query = $this->m_resep->delete_item_temp($id);
	// 	if ($query) {
	// 		$d["status"] = 1;
	// 		$d["detail"] = '';
	// 		$query_detail = $this->m_resep->getDataResepDetailTempByUser();
	// 		$qty = 0;
	// 		$total = 0;
	// 		foreach ($query_detail->result_array() as $row_d) {
	// 			$d["detail"] .= '<tr>
	// 			<td hidden>' . $row_d['ob_code'] . '</td>
	// 			<td>' . $row_d['ob_name'] . '</td>
	// 			<td>' . $row_d['rsp_qty'] . '</td>
	// 			<td>' . $row_d['sat_name'] . '</td>
	// 			<td>' . $row_d['saldo'] . '</td>
	// 			<td>' . number_format($row_d['ob_jual']) . '</td>
	// 			<td>' . number_format($row_d['ob_amount']) . '</td>
	// 			<td>' . $row_d['rsp_cara'] . '</td>
	// 			<td>' . $row_d['rsp_dosis'] . '</td>
	// 			<td>' . $row_d['rsp_jam'] . '</td>
	// 			<td>' . $row_d['rsp_sat_minum'] . '</td>
	// 			<td>' . $row_d['ob_racik'] . '</td>
	// 			<td><a onclick="delete_item(&apos;'.$row_d['id'].'&apos;)" class="btn btn-danger btn-xs"><span class="fa fa-trash"></span></a></td>
	// 			</tr>
	// 			';

	// 			$qty = $qty + $row_d['rsp_qty'];
	// 			$total = $total + $row_d['ob_amount'];
	// 		}

	// 		$d["detail"] .= '<tr style="font-weight:bold;">
	// 		<td>Total</td>
	// 		<td>' . $qty . '</td>
	// 		<td colspan=3></td>
	// 		<td>' . number_format($total) . '</td>
	// 		<td colspan=6></td>
	// 		</tr>';
	// 	} else {
	// 		$d["status"] = 0;
	// 	}

	// 	echo json_encode($d);
	// }

	// public function stok()
	// {

	// 	$ob_code = $this->input->post("ob_code");

	// 	try {
	// 		$this->db->reconnect();
	// 		$sql = "CALL `p_m_inv_obat_form_apotik_by_kode`('$ob_code')";
	// 		$result = $this->db->query($sql)->row();
	// 		$this->db->close();
	// 	} catch (Exception $e) {
	// 		echo $e->getMessage();
	// 	}

	// 	$r['ob_code'] = $result->ob_code;
	// 	$r['ob_harga'] = $result->ob_jual;
	// 	$r['ob_beli'] = $result->ob_beli;
	// 	$r['stok'] = $result->saldo;


	// 	echo json_encode($r);
	// }

	// public function data()
	// {
	// 	$reg_bukti_no = $this->uri->segment(3);
	// 	$dt['data'] = $this->m_resep->getDataResepById($reg_bukti_no);
	// 	$this->template->display('v_resep', $dt);
	// }

	// public function add()
	// {
	// 	$reg_bukti_no = $this->uri->segment(4);
	// 	$dt['data'] = $this->m_resep->getDataById($reg_bukti_no);
	// 	$dt['instalasi'] = $this->m_master->instalasi();
	// 	$dt['dokter'] = $this->m_master->dokter();
	// 	$dt['obat'] = $this->m_master->obat();
	// 	$this->template->display('v_resep_add', $dt);
	// }

	// public function add2()
	// {
	// 	$reg_bukti_no = $this->uri->segment(3);
	// 	$dt['data'] = $this->m_resep->getDataById($reg_bukti_no);
	// 	$dt['instalasi'] = $this->m_master->instalasi();
	// 	$dt['dokter'] = $this->m_master->dokter();
	// 	$dt['obat'] = $this->m_master->obat();
	// 	$this->template->display('v_resep2_add', $dt);
	// }

	// public function get_obat()
	// {

	// 	$ob_name = $this->input->post("kodbar");

	// 	// $query = $this->db->query("SELECT * FROM v_m_inv_obat_form_apotik WHERE concat('(',ob_code,') ',ob_name)='$ob_name'")->row();

	// 	try {
	// 		$this->db->reconnect();
	// 		$sql = "CALL `p_m_inv_obat_form_apotik`('$ob_name')";
	// 		$result = $this->db->query($sql)->row();
	// 		$this->db->close();
	// 	} catch (Exception $e) {
	// 		echo $e->getMessage();
	// 	}

	// 	$json['ob_code'] = $result->ob_code;
	// 	$json['ob_harga'] = $result->harga;
	// 	$json['stok'] = $result->saldo;

	// 	echo json_encode($json);
	// 	// die();

	// }

	// public function edit()
	// {
	// 	$rsp_bukti_no = $this->uri->segment(3);
	// 	$dt['data'] = $this->m_resep->getDataResepDetailById($rsp_bukti_no);
	// 	$dt['instalasi'] = $this->m_master->instalasi();
	// 	$dt['dokter'] = $this->m_master->dokter();
	// 	$dt['obat'] = $this->m_master->obat();
	// 	$this->template->display('v_resep_edit', $dt);
	// }

	// public function add_header()
	// {


	// 	$kode = $this->m_resep->kode();
	// 	$reg_bukti_no = $this->input->post("reg_bukti_no");
	// 	$dok_code = $this->input->post("dok_code");
	// 	$pas_name = $this->input->post("pas_name");

	// 	if ($_POST) {
	// 		$query = $this->m_resep->add_header($kode, $reg_bukti_no, $dok_code, $pas_name);

	// 		if ($query) {
	// 			$d["status"] = 1;
	// 			$d["bukti_no"] = $kode;
	// 		}
	// 	} else {
	// 		$d["status"] = 0;
	// 	}

	// 	echo json_encode($d);
	// }
}

/* End of file Kategori.php */
/* Location: ./application/controllers/Kategori.php */