<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Bhp extends CI_Controller {

	public function __construct(){
		parent::__construct();
		$this->load->library('template');

		$this->load->model('m_bhp');
		$this->load->model('default_mdl');
		$this->load->model('m_master');
	}

	public function index()
	{

		
		$dt['data'] = $this->m_bhp->getData();
		$this->template->display('v_data_pasien_bhp',$dt);
	}

	public function data()
	{
		$reg_bukti_no = $this->uri->segment(3);
		$dt['data'] = $this->m_bhp->getDataResepById($reg_bukti_no);
		$this->template->display('v_bhp',$dt);
	}

	public function add()
	{
		$reg_bukti_no = $this->uri->segment(3);
		$dt['data'] = $this->m_bhp->getDataById($reg_bukti_no);
		$dt['instalasi'] = $this->m_master->instalasi();
		$dt['dokter'] = $this->m_master->dokter();
		$dt['obat'] = $this->m_master->obat();
		$this->template->display('v_bhp_add',$dt);
	}
	
	public function edit()
	{
		$alkes_bukti_no = $this->uri->segment(3);
		$dt['data'] = $this->m_bhp->getDataResepDetailById($alkes_bukti_no);
		$dt['instalasi'] = $this->m_master->instalasi();
		$dt['dokter'] = $this->m_master->dokter();
		$dt['obat'] = $this->m_master->obat();
		$this->template->display('v_bhp_edit',$dt);
	}

	public function add_header()
	{

		
		$kode = $this->m_bhp->kode();
		$reg_bukti_no = $this->input->post("reg_bukti_no");

		if($_POST){
			$query = $this->m_bhp->add_header($kode,$reg_bukti_no);

			if($query){
				$d["status"] = 1;
				$d["bukti_no"] = $kode;

			}
		} else {
			$d["status"] = 0;
		}

		echo json_encode($d);

	}

	public function cetak(){

		$alkes_bukti_no = $this->uri->segment(3);

		ob_start();    


		#ambil data di tabel dan masukkan ke array
		$data['data'] = $this->m_bhp->cetak($alkes_bukti_no);
		$this->load->view('cetak',$data);

		$content = ob_get_clean();               
		require_once('./html2pdf/html2pdf.class.php');    
		try
		{
			$html2pdf = new HTML2PDF('L', array(40,65), 'en', true, 'UTF-8', array(1, 1, 1, 1));
			$html2pdf->pdf->SetDisplayMode('fullpage');
			$html2pdf->writeHTML($content, isset($_GET['vuehtml']));
			$html2pdf->Output('etiket.pdf');
		}
		catch(HTML2PDF_exception $e) {
			echo $e;
			exit;
		}


	}

	public function add_item()
	{

		
		$alkes_bukti_no = $this->input->post("alkes_bukti_no");
		$ob_code = $this->input->post("ob_code");
		$ob_qty = $this->input->post("ob_qty");
		// $ob_harga = $this->input->post("ob_harga");
		$stok = $this->input->post("stok");

		if($_POST){

			$h = $this->db->query("SELECT ob_jual FROM m_inv_obat WHERE ob_code='$ob_code'")->row_array();
			$ob_harga = $h['ob_jual'];

			$query = $this->m_bhp->add_item($alkes_bukti_no,$ob_code,$ob_qty,$ob_harga,$stok);

			if($query){
				
				$d["status"] = 1;
				$d["detail"] = "";

				$query_detail = $this->m_bhp->getDataResepDetailById($alkes_bukti_no);
				
				foreach ($query_detail->result_array() as $row_d) {
					$d["detail"] .= '<tr>
										<td hidden>'.$row_d['ob_code'].'</td>
										<td>'.$row_d['ob_name'].'</td>
										<td>'.$row_d['ob_qty'].'</td>
										<td>'.$row_d['sat_name'].'</td>
										<td>'.$row_d['saldo'].'</td>
										<td>'.number_format($row_d['ob_harga']).'</td>
										<td>'.number_format($row_d['ob_amount']).'</td>
										<td><a data-alkes_bukti_no="'.$row_d['alkes_bukti_no'].'" data-id="'.$row_d['ob_code'].'" id="delete_item" class="btn btn-danger btn-xs"><span class="fa fa-trash"></span></a></td>
									</tr>';
				}



			}
		} else {
			$d["status"] = 0;
		}

		echo json_encode($d);

	}
	

	public function delete_item(){

		$alkes_bukti_no = $this->input->post("alkes_bukti_no");
		$id = $this->input->post("id");
		$query = $this->m_bhp->delete_item($alkes_bukti_no,$id);
		$query_ins = $this->m_bhp->delete_item_jual($alkes_bukti_no,$id);

		if($query){
			$output = "";
			$query_detail = $this->m_bhp->getDataResepDetailById($alkes_bukti_no);
				
			foreach ($query_detail->result_array() as $row_d) {
				$output .= '<tr>
									<td hidden>'.$row_d['ob_code'].'</td>
									<td>'.$row_d['ob_name'].'</td>
									<td>'.$row_d['ob_qty'].'</td>
									<td>'.$row_d['sat_name'].'</td>
									<td>'.$row_d['saldo'].'</td>
									<td>'.number_format($row_d['ob_harga']).'</td>
									<td>'.number_format($row_d['ob_amount']).'</td>
									<td><a data-alkes_bukti_no="'.$row_d['alkes_bukti_no'].'" data-id="'.$row_d['ob_code'].'" id="delete_item" class="btn btn-danger btn-xs"><span class="fa fa-trash"></span></a></td>
								</tr>';
			}
		} else {
			$output = 0;
		}

		echo $output;
		


	}

	public function delete(){

		$alkes_bukti_no = $this->input->post("alkes_bukti_no");
		$query = $this->m_bhp->delete($alkes_bukti_no);

		if($query){
			$output = 1;
		} else {
			$output = 0;
		}

		echo $output;
		


	}

	public function stok()
	{
		
		$ob_code = $this->input->post("ob_code");

		$row = $this->m_master->stok($ob_code)->row_array();

		$r['saldo'] = $row['saldo'];
		$r['harga'] = $row['ob_jual'];

		echo json_encode($r);


	}
	





}

/* End of file Kategori.php */
/* Location: ./application/controllers/Kategori.php */